document.getElementById('start-button').addEventListener('click', startGame);

let currentBGM = '';
let bgmPosition = 0;
let bgmElement = document.getElementById('bgm');

// 変数管理オブジェクト
let gameVariables = {
    scene1VisitedCount: 0,
};
// スイッチの状態管理オブジェクト
let switches = {
    'switch1': false, // 任意のスイッチ名で初期値は false
    'switch2': false
};

function startGame() {
    document.getElementById('title-screen').style.display = 'none';
    document.getElementById('game-screen').style.display = 'block';
    showScene(0);
}

const scenes = [
    {
        id: 0, 
        background: 'scene1.jpg',
        defaultLeftCharacter: 'character1.png',
        defaultCenterCharacter: 'character-center.png',
        defaultRightCharacter: 'character2.png',
        dialogue: 'これは最初のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx1.mp3',
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号0', nextScene: 0 }
        ],
        switches: {
            'switch1': true // このシーンで switch1 をオンにする
            },
            alternateScenes: {
                'switchx': {
                    background: 'alternate_scene1.jpg',
                    leftCharacter: 'character_alt1.png',
                    centerCharacter: 'character_alt_center.png',
                    rightCharacter: 'character_alt2.png',
                    dialogue: 'これはスイッチ1がオンの場合のシーンです。',
                    bgm: './data/bgm/another_bgm.mp3',
                    sfx: 'another_sfx.mp3',
                    choices: [
                        { text: '選択肢3', nextScene: 3 },
                        { text: '選択肢0', nextScene: 0 }
                    ]
                }
            }
    },
    {
        id: 1,
        background: 'scene2.jpg',
        defaultLeftCharacter: 'character1.png',
        defaultCenterCharacter: './data/img/character/lira.png',
        defaultRightCharacter: 'character3.png',
        dialogue: 'これは2番目のシーンです。',
        bgm: './data/bgm/another_bgm.mp3',
        sfx: 'sfx2.mp3',
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号２', nextScene: 2 }
        ],
        switches: {}
    },
    {
        id: 2,
        background: 'scene3.jpg',
        defaultLeftCharacter: 'character2.png',
        defaultCenterCharacter: 'character-center.png',
        defaultRightCharacter: 'character3.png',
        dialogue: 'これは3番目のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx3.mp3',
        choices: [
            { text: '選択肢1', nextScene: 1 },
            { text: '選択肢2', nextScene: 2 }
        ],
        switches: {}
    },
    {
        id: 3,
        background: 'scene3.jpg',
        defaultLeftCharacter: 'character2.png',
        defaultCenterCharacter: 'character-center.png',
        defaultRightCharacter: 'character3.png',
        dialogue: 'ゲームオーバー',
        bgm: './data/bgm/',
        sfx: 'sfx3.mp3',
        choices: [
            { text: '選択肢1', nextScene: 1 }
        ],
        switches: {}
    }
];

function setSwitch(switchName, state) {
    if (switches.hasOwnProperty(switchName)) {
        switches[switchName] = state;
    } else {
        console.error("Switch not found:", switchName);
    }
}


function showScene(index) {
    const scene = scenes.find(s => s.id === index);
    if (!scene) {
        console.error("Scene not found:", index);
        return;
    }

    // シーン訪問回数をカウント
    if (scene.id === 1) {
        gameVariables.scene1VisitedCount++;
    }

    // 分岐時に使える置き換えの変数
    let leftCharacter = scene.defaultLeftCharacter;
    let centerCharacter = scene.defaultCenterCharacter;
    let rightCharacter = scene.defaultRightCharacter;
    let dialogue = scene.dialogue;
    let choices = scene.choices;
    let background = scene.background;
    let bgm = scene.bgm;
    let sfx = scene.sfx;

    // 条件分岐でスイッチの状態を変更
    if (gameVariables.scene1VisitedCount >= 2) {
        setSwitch('switchx', true); // スイッチをtrueにする
        centerCharacter = './data/img/character/lira1.png';
        dialogue = '何度もここに来たね。';
        choices = [{ text: '選択肢3', nextScene: 3 }, { text: '選択肢0', nextScene: 0 }];
        background = 'scene4.jpg';
        bgm = './data/bgm/another_bgm.mp3';
        sfx = 'another_sfx.mp3';
        gameVariables.scene1VisitedCount = 0; // 訪問回数リセット
    }

    // スイッチの状態を更新
    for (const [key, value] of Object.entries(scene.switches)) {
        setSwitch(key, value);
    }

    // 条件分岐で別の場面に書き換え
    if (scene.alternateScenes) {
        for (const [key, altScene] of Object.entries(scene.alternateScenes)) {
            if (switches[key]) {
                Object.assign(scene, altScene);
            }
        }
    }

    document.getElementById('background').style.backgroundImage = `url(${background})`;
    document.getElementById('left-character').style.backgroundImage = `url(${leftCharacter})`;
    document.getElementById('center-character').style.backgroundImage = `url(${centerCharacter})`;
    document.getElementById('right-character').style.backgroundImage = `url(${rightCharacter})`;
    changeBGM(bgm);
    playSFX(sfx);
    typeDialogue(dialogue, () => {
        if (choices.length > 0) {
            showChoices(choices);
        }
    });
}




//... (その他の関数は変更なし)
// 以下ver1.3同様関数。
// bgm再生
function changeBGM(bgm) {
    if (bgm === currentBGM) {
        bgmElement.currentTime = bgmPosition;
        bgmElement.play();
    } else {
        fadeOut(bgmElement, () => {
            bgmElement.src = bgm;
            bgmElement.currentTime = 0;
            bgmElement.play();
            fadeIn(bgmElement);
            currentBGM = bgm;
            bgmPosition = 0;
        });
    }
}
// フェードイン
function fadeIn(audioElement) {
    let volume = 0;
    audioElement.volume = volume;
    const fadeInInterval = setInterval(() => {
        if (volume < 1) {
            volume += 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeInInterval);
        }
    }, 100);
}
// フェードアウト
function fadeOut(audioElement, callback) {
    let volume = audioElement.volume;
    const fadeOutInterval = setInterval(() => {
        if (volume > 0) {
            volume -= 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeOutInterval);
            callback();
        }
    }, 100);
}

function playSFX(sfx) {
    const sfxElement = new Audio(sfx);
    sfxElement.play();
}

bgmElement.addEventListener('timeupdate', () => {
    bgmPosition = bgmElement.currentTime;
});

function typeDialogue(text, callback) {
    const dialogueText = document.getElementById('dialogue-text');
    dialogueText.textContent = '';
    let i = 0;
    const typingSpeed = 50;
    const interval = setInterval(() => {
        if (i < text.length) {
            dialogueText.textContent += text.charAt(i);
            i++;
        } else {
            clearInterval(interval);
            setTimeout(callback, 500);
        }
    }, typingSpeed);
}

function showChoices(choices) {
    const choicesContainer = document.getElementById('choices');
    choicesContainer.style.display = 'block';
    choicesContainer.innerHTML = '';
    choices.forEach(choice => {
        const button = document.createElement('button');
        button.className = 'choice-button';
        button.textContent = choice.text;
        button.addEventListener('click', () => {
            choicesContainer.style.display = 'none';
            showScene(choice.nextScene);
        });
        choicesContainer.appendChild(button);
    });
}
